/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.security;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.security.ISecurityCard;
import com.refinedmods.refinedstorage.api.network.security.ISecurityCardContainer;
import com.refinedmods.refinedstorage.api.network.security.ISecurityManager;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.world.entity.player.Player;

public class SecurityManager
implements ISecurityManager {
    private final INetwork network;
    private final Map<UUID, ISecurityCard> cards = new HashMap<UUID, ISecurityCard>();
    private ISecurityCard globalCard;

    public SecurityManager(INetwork network) {
        this.network = network;
    }

    @Override
    public boolean hasPermission(Permission permission, Player player) {
        ServerOpList ops = player.m_20194_().m_6846_().m_11307_();
        if (ops.m_11388_((Object)player.m_36316_()) != null) {
            return true;
        }
        UUID uuid = player.m_36316_().getId();
        if (!this.cards.containsKey(uuid)) {
            if (this.globalCard != null) {
                return this.globalCard.hasPermission(permission);
            }
            return true;
        }
        return this.cards.get(uuid).hasPermission(permission);
    }

    @Override
    public void invalidate() {
        this.cards.clear();
        this.globalCard = null;
        for (INetworkNodeGraphEntry entry : this.network.getNodeGraph().all()) {
            if (!(entry.getNode() instanceof ISecurityCardContainer) || !entry.getNode().isActive()) continue;
            ISecurityCardContainer container = (ISecurityCardContainer)((Object)entry.getNode());
            for (ISecurityCard card : container.getCards()) {
                if (card.getOwner() == null) {
                    throw new IllegalStateException("Owner in #getCards() cannot be null!");
                }
                this.cards.put(card.getOwner(), card);
            }
            if (container.getGlobalCard() == null) continue;
            this.globalCard = container.getGlobalCard();
        }
    }
}

